import 'package:admin_desktop/domain/models/data/comments_data.dart';
import 'package:admin_desktop/infrastructure/services/extensions.dart';
import 'package:admin_desktop/infrastructure/services/time_service.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/comments/widgets/show_comment_modal.dart';
import 'package:custom_rating_bar/custom_rating_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:remixicon_updated/remixicon_updated.dart';

import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/application/comments/comments_notifier.dart';
import 'package:admin_desktop/application/comments/comments_state.dart';
import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/infrastructure/services/tr_keys.dart';
import 'package:admin_desktop/presentation/components/buttons/has_more_button.dart';
import 'package:admin_desktop/presentation/components/custom_checkbox.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'mini_button.dart';

class ShopCommentTable extends StatefulWidget {
  final CommentsState commentsState;
  final CommentsNotifier notifier;

  const ShopCommentTable({
    super.key,
    required this.commentsState,
    required this.notifier,
  });

  @override
  State<ShopCommentTable> createState() => _ShopCommentTableState();
}

class _ShopCommentTableState extends State<ShopCommentTable> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: LayoutBuilder(
        builder: (context, constraints) {
          return Padding(
            padding: const EdgeInsets.symmetric(horizontal: 16),
            child: Column(
              children: [
                20.verticalSpace,
                _topRow(constraints, widget.notifier, widget.commentsState),
                Expanded(
                  child: ListView(
                    children: [
                      widget.commentsState.isLoading
                          ? _loading()
                          : widget.commentsState.shopComments.isEmpty
                          ? Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                70.verticalSpace,
                                Text(
                                  AppHelpers.getTranslation(TrKeys.empty),
                                  style: Style.interNormal(),
                                ),
                              ],
                            )
                          : Column(
                              children: [
                                ...widget.commentsState.shopComments.mapIndexed(
                                  (e, i) {
                                    return _tableRow(constraints, e);
                                  },
                                ),
                              ],
                            ),
                      12.verticalSpace,
                      HasMoreButton(
                        hasMoreLoading: widget.commentsState.hasMoreLoading,
                        hasMore: widget.commentsState.hasMoreShopComment,
                        onViewMore: () {
                          widget.notifier.fetchShopComments();
                        },
                      ),
                      12.verticalSpace,
                    ],
                  ),
                ),
              ],
            ),
          );
        },
      ),
    );
  }

  Widget _tableRow(BoxConstraints constraints, CommentsData comment) {
    return Container(
      width: double.infinity,
      height: 80,
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.only(
          // topLeft: Radius.circular(AppConstants.radius),
          // topRight: Radius.circular(AppConstants.radius),
        ),
        border: Border.fromBorderSide(BorderSide(color: Style.greyColor)),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          12.horizontalSpace,
          CustomCheckbox(
            isActive: widget.commentsState.selectedShopIds.contains(comment.id),
            onTap: () {
              widget.notifier.addSelectShop(
                id: comment.id,
                orderLength: widget.commentsState.shopComments.length,
              );
            },
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 18,
            child: Text("${comment.id ?? 0}"),
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 5,
            child: Text(
              "${comment.user?.firstname ?? " -"} ${comment.user?.lastname ?? ""}",
            ),
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 5,
            child: Text("${comment.comment}"),
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 7,
            child: RatingBar.readOnly(
              filledIcon: Icons.star,
              emptyIcon: Icons.star_border,
              size: 20,
              initialRating: comment.rating?.toDouble() ?? 0,
              maxRating: 5,
            ),
          ),
          12.horizontalSpace,
          if (constraints.maxWidth > 1100)
            SizedBox(
              width: constraints.maxWidth / 9,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Text(TimeService.dateFormatMDYHm(comment.createdAt)),
                ],
              ),
            ),
          Spacer(),
          SizedBox(
            width: 100,
            child: Row(
              children: [
                MiniButton(
                  icon: Remix.eye_line,
                  color: Style.primary,
                  iconColor: Style.white,
                  onTap: () {
                    AppHelpers.showAlertDialog(
                      context: context,
                      child: ShowCommentModal(comment: comment),
                    );
                  },
                ),
                // Spacer(),
                // MiniButton(
                //   color: Style.greyColor,
                //   icon: Remix.delete_bin_6_fill,
                //   onTap: () {
                //     AppHelpers.showAlertDialog(
                //       context: context,
                //       child: DeleteDialog(
                //         success: () {
                //           widget.notifier.deleteComment(context, comment.id!);
                //           Navigator.of(context, rootNavigator: true).pop();
                //         },
                //       ),
                //     );
                //   },
                // ),
              ],
            ),
          ),
          12.horizontalSpace,
        ],
      ),
    );
  }

  Container _topRow(
    BoxConstraints constraints,
    CommentsNotifier notifier,
    CommentsState state,
  ) {
    return Container(
      width: double.infinity,
      height: 60,
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(AppConstants.radius),
          topRight: Radius.circular(AppConstants.radius),
        ),
        border: Border.fromBorderSide(BorderSide(color: Style.greyColor)),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          12.horizontalSpace,
          CustomCheckbox(
            isActive: state.isAllSelectShop,
            onTap: () {
              notifier.allSelectShop(state.shopComments);
            },
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 18,
            child: Text(
              AppHelpers.getTranslation(TrKeys.id),
              style: Style.interMedium(),
            ),
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 5,
            child: Text(
              AppHelpers.getTranslation(TrKeys.users),
              style: Style.interMedium(),
            ),
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 5,
            child: Text(
              AppHelpers.getTranslation(TrKeys.comment),
              style: Style.interMedium(),
            ),
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 7,
            child: Text(
              AppHelpers.getTranslation(TrKeys.rating),
              style: Style.interMedium(),
            ),
          ),
          12.horizontalSpace,
          if (constraints.maxWidth > 1100)
            SizedBox(
              width: constraints.maxWidth / 9,
              child: Text(
                AppHelpers.getTranslation(TrKeys.createdDate),
                style: Style.interMedium(),
              ),
            ),
          Spacer(),
          SizedBox(
            width: 100,
            child: Text(
              AppHelpers.getTranslation(TrKeys.options),
              style: Style.interMedium(),
            ),
          ),
          12.horizontalSpace,
        ],
      ),
    );
  }

  ListView _loading() {
    return ListView.builder(
      itemCount: 10,
      shrinkWrap: true,
      itemBuilder: (context, index) {
        return Container(
          height: 80,
          width: double.infinity,
          decoration: BoxDecoration(
            color: Style.greyColor,
            border: Border.fromBorderSide(BorderSide(color: Style.white)),
          ),
        );
      },
    );
  }
}
